/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.updates.AllMCFControlFileFilter;
import com.ibm.hwmca.base.updates.BaseUpdatesOwner;
import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.base.updates.MCL;
import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.Update;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ECStream
extends UpdateableComponent
implements MCLErrorIds {
    private static final String TRACE_MASKT = "XMCLECST";
    private static final String TRACE_MASKF = "XMCLECSF";
    private static final String TRACE_MASKD = "XMCLECSD";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");
    private String id;
    private String partNumber;
    private Date appliedDate;
    private int appliedLevel;
    private Date committedDate;
    private int committedLevel;
    private LocalizableText description;
    private String name;
    private Date stagedDate;
    private int stagedLevel;
    private List uncollectedUpdates;
    private List updateCollections;
    private LocalizableText displayableError;
    private String stagingAreaPath;
    private String fileWithPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ECStream(BaseUpdatesOwner owner, String fileName) throws HException {
        block13: {
            super(owner);
            in = null;
            Trace.trace("XMCLECST", "-> ECStream()");
            try {
                this.stagingAreaPath = BaseFileControl.getFilePath("iqzmcf.mcf");
                ecDirectory = BaseFileControl.getFilePath(fileName);
                Trace.trace("XMCLECSD", "ecDirectory=[" + ecDirectory + "]");
                Trace.trace("XMCLECSD", "fileName=[" + fileName + "]");
                try {
                    this.fileWithPath = ecDirectory + fileName;
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileWithPath)));
                    this.name = this.readString((DataInputStream)in, 7);
                    this.skipBytes((DataInputStream)in, 1);
                    this.partNumber = this.readString((DataInputStream)in, 8);
                    this.skipBytes((DataInputStream)in, 4);
                    this.id = this.readString((DataInputStream)in, 6);
                    this.skipBytes((DataInputStream)in, 4);
                    this.stagedLevel = this.readLevel((DataInputStream)in);
                    this.stagedDate = this.readECDate((DataInputStream)in);
                    this.skipBytes((DataInputStream)in, 11);
                    this.appliedLevel = this.readLevel((DataInputStream)in);
                    this.appliedDate = this.readECDate((DataInputStream)in);
                    this.committedLevel = this.readLevel((DataInputStream)in);
                    this.committedDate = this.readECDate((DataInputStream)in);
                    this.skipBytes((DataInputStream)in, 11);
                    this.skipBytes((DataInputStream)in, 11);
                    this.skipBytes((DataInputStream)in, 11);
                    this.description = new LocalizableText(this.readString((DataInputStream)in, 65));
                    this.updateCollections = new ArrayList<E>();
                    firstLevel = this.committedLevel + 1;
                    if (firstLevel == 0) {
                        firstLevel = 1;
                    }
                    for (nextLevel = firstLevel; nextLevel <= this.stagedLevel; ++nextLevel) {
                        this.updateCollections.add(new MCL(this, nextLevel));
                    }
                    var8_9 = null;
                    if (null == in) break block13;
                    ** GOTO lbl-1000
                }
                catch (IOException e) {
                    this.logError("IO error =" + e, (short)-4031);
                    var8_10 = null;
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            this.logError("Error on close of EC file =" + e, (short)-4030);
                        }
                    }
                    break block13;
                }
                {
                    catch (Throwable var7_15) {
                        var8_11 = null;
                        if (null == in) throw var7_15;
                        ** try [egrp 3[TRYBLOCK] [4 : 410->417)] { 
lbl57:
                        // 1 sources

                        in.close();
                        throw var7_15;
lbl59:
                        // 1 sources

                        catch (IOException e) {
                            this.logError("Error on close of EC file =" + e, (short)-4030);
                        }
                        throw var7_15;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {}
                    this.logError("Error on close of EC file =" + e, (short)-4030);
                    in.close();
                }
            }
            catch (HException hexc) {
                this.logError("Unable to access staging area", (short)-4032, hexc);
            }
        }
        Trace.trace("XMCLECST", "<- ECStream()");
    }

    public String getECNumber() {
        return this.id;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public LocalizableText getDescription() {
        return this.description;
    }

    public LocalizableText getDisplayableError() {
        return this.displayableError;
    }

    public Date getAppliedDate() {
        Date out = this.appliedDate;
        if (out != null) {
            out = (Date)this.appliedDate.clone();
        }
        return out;
    }

    public int getAppliedLevel() {
        Trace.trace(TRACE_MASKD, "<> getAppliedLevel returns " + this.appliedLevel);
        return this.appliedLevel;
    }

    public Date getCommittedDate() {
        Date out = this.committedDate;
        if (out != null) {
            out = (Date)this.committedDate.clone();
        }
        return out;
    }

    public int getCommittedLevel() {
        Trace.trace(TRACE_MASKD, "<> getCommittedLevel returns " + this.committedLevel);
        return this.committedLevel;
    }

    public String getName() {
        return this.name;
    }

    public int getNonDisruptiveApplyLevel() {
        return this.stagedLevel;
    }

    public int getNonDisruptiveRejectLevel() {
        return -1;
    }

    public String getStagingAreaPath() {
        return this.stagingAreaPath;
    }

    public Date getStagedDate() {
        Date out = this.stagedDate;
        if (out != null) {
            out = (Date)this.stagedDate.clone();
        }
        return out;
    }

    public int getStagedLevel() {
        Trace.trace(TRACE_MASKD, "<> getStagedLevel returns " + this.stagedLevel);
        return this.stagedLevel;
    }

    public List getUncollectedUpdates() {
        Trace.trace(TRACE_MASKT, "-> getUncollectedUpdates()");
        this.uncollectedUpdates = new ArrayList();
        File stagingArea = new File(this.stagingAreaPath);
        String[] files = stagingArea.list(new AllMCFControlFileFilter(this));
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                Trace.trace(TRACE_MASKF, "The MCF " + files[i] + " is in the EC.");
                int dotPosition = files[i].indexOf(".");
                String fileExtension = files[i].substring(dotPosition + 1);
                String thisMCFid = fileExtension.equals("xml") ? files[i].substring(dotPosition - 3, dotPosition) : fileExtension;
                Trace.trace(TRACE_MASKD, "thisMCFid=[" + thisMCFid + "].");
                boolean found = false;
                ListIterator counterOfMCLs = this.updateCollections.listIterator();
                while (!found && counterOfMCLs.hasNext()) {
                    UpdateCollection nextMCL = (UpdateCollection)counterOfMCLs.next();
                    List mcfs = nextMCL.getUpdates();
                    ListIterator counterOfMCFs = mcfs.listIterator();
                    while (!found && counterOfMCFs.hasNext()) {
                        Update nextMCF = (Update)counterOfMCFs.next();
                        String id = nextMCF.getId();
                        Trace.trace(TRACE_MASKD, "Compare to id=[" + id + "].");
                        if (!thisMCFid.equals(id)) continue;
                        found = true;
                    }
                }
                if (found) continue;
                try {
                    this.uncollectedUpdates.add(new MCF(this, files[i]));
                    continue;
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKF, "The MCF" + files[i] + "could not be constructed.");
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getUncollectedUpdates()");
        return this.uncollectedUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getCommittedUpdates() {
        ArrayList<MCF> committedUpdates;
        block11: {
            Trace.trace(TRACE_MASKT, "-> getCommittedUpdates()");
            committedUpdates = new ArrayList<MCF>();
            BufferedReader instream = null;
            String acceptHistoryFile = this.id + "ac.dat";
            String acceptHistoryPath = BaseFileControl.getFilePath("ac.dat");
            acceptHistoryFile = acceptHistoryPath + acceptHistoryFile;
            instream = new BufferedReader(new FileReader(acceptHistoryFile));
            String acceptHistoryLine = instream.readLine();
            while (null != acceptHistoryLine) {
                StringTokenizer tokens = new StringTokenizer(acceptHistoryLine, "~");
                String updateCollectionID = tokens.nextToken();
                String updateId = tokens.nextToken();
                String updateDescription = tokens.nextToken();
                UserContext userContext = UserContext.getCurrentUserContext();
                DateFormat formatter = null;
                if (userContext != null) {
                    formatter = DateFormat.getDateTimeInstance(2, 2, userContext.getLocale());
                    formatter.setTimeZone(userContext.getTimeZone());
                } else {
                    formatter = DateFormat.getDateTimeInstance();
                }
                Date acceptedDate = formatter.parse(tokens.nextToken());
                committedUpdates.add(new MCF(this, updateCollectionID, updateId, updateDescription, acceptedDate));
                acceptHistoryLine = instream.readLine();
            }
            Object var14_14 = null;
            try {
                instream.close();
            }
            catch (IOException e2) {
                this.logError("Error on close of EC file =" + e2, (short)-4028, e2);
            }
            break block11;
            {
                catch (Exception e) {
                    this.logError("IO error =" + e, (short)-4029, e);
                    Object var14_15 = null;
                    try {
                        instream.close();
                    }
                    catch (IOException e2) {
                        this.logError("Error on close of EC file =" + e2, (short)-4028, e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    instream.close();
                }
                catch (IOException e2) {
                    this.logError("Error on close of EC file =" + e2, (short)-4028, e2);
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- getCommittedUpdates()");
        return committedUpdates;
    }

    public List getUpdateCollections() {
        Trace.trace(TRACE_MASKT, "<> getUpdateCollections returns " + this.updateCollections.size() + " collections.");
        return this.updateCollections;
    }

    public boolean isRemoteSupportSystemAvailable() {
        Trace.trace(TRACE_MASKT, "-> isRemoteSupportSystemAvailable");
        RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
        boolean isAvailable = false;
        if (rsf != null) {
            isAvailable = rsf.isCallHomeServerAvailable();
        }
        Trace.trace(TRACE_MASKT, "<- isRemoteSupportSystemAvailable: " + isAvailable);
        return isAvailable;
    }

    public void addMCL(MCL mclToAdd) throws HException {
        Trace.trace(TRACE_MASKT, "-> addMCL");
        int id = mclToAdd.getId();
        if (this.stagedLevel == id - 1 || -1 == this.stagedLevel) {
            Date changeDate = mclToAdd.getLastStatusChangeDate();
            this.updateCollections.add(mclToAdd);
            this.setStagedLevel(id, changeDate);
        } else {
            this.logError("MCL being added " + id + "is out of sequence.", (short)-3896);
        }
        Trace.trace(TRACE_MASKT, "<- addMCL");
    }

    public void removeMCL(MCL mclToRemove) throws HException {
        Trace.trace(TRACE_MASKT, "-> removeMCL");
        int id = mclToRemove.getId();
        if (this.stagedLevel == id && this.appliedLevel < id) {
            boolean foundIt = this.updateCollections.remove(mclToRemove);
            if (!foundIt) {
                this.logError("MCL " + id + " being deleted, but not in list of update collections for EC " + this.getECNumber(), (short)-3894);
            }
            Date changeDate = new Date();
            this.setStagedLevel(id - 1, changeDate);
        } else if ((id == this.committedLevel + 1 || id == 1 && this.committedLevel == -1) && id <= this.appliedLevel) {
            boolean foundIt = this.updateCollections.remove(mclToRemove);
            if (!foundIt) {
                this.logError("MCL " + id + " being accepted, but not in list of update collections for EC " + this.getECNumber(), (short)-3893);
            }
            Date changeDate = new Date();
            this.setCommittedLevel(id, changeDate);
        } else {
            this.logError("MCL being removed " + id + " is out of sequence.", (short)-3895);
        }
        Trace.trace(TRACE_MASKT, "<- removeMCL");
    }

    public boolean isUpdatingEnabled() {
        short count;
        Trace.trace(TRACE_MASKT, "-> isUpdatingEnabled");
        boolean isEnabled = false;
        BaseTower baseTower = BaseTower.getBaseTower();
        if (!baseTower.isUpdatingDisabled() && (count = baseTower.getTemporaryFixesActivated()) == 0 && (count = baseTower.getPermanentFixesActivated()) == 0) {
            isEnabled = true;
        }
        Trace.trace(TRACE_MASKT, "<- isUpdatingEnabled returns " + (isEnabled ? "true" : "false"));
        return isEnabled;
    }

    public void setAppliedLevel(int appliedLevel, Date appliedDate) {
        this.appliedLevel = appliedLevel;
        this.appliedDate = (Date)appliedDate.clone();
        this.persistECStream(false, true, false);
    }

    private void setCommittedLevel(int committedLevel, Date committedDate) {
        this.committedLevel = committedLevel;
        this.committedDate = (Date)committedDate.clone();
        this.persistECStream(false, false, true);
    }

    public void setStagedLevel(int stagedLevel, Date stagedDate) {
        this.stagedLevel = stagedLevel;
        this.stagedDate = (Date)stagedDate.clone();
        this.persistECStream(true, false, false);
    }

    protected String readString(DataInputStream in, int byteCount) throws IOException {
        int i;
        byte[] buffer = new byte[byteCount];
        in.readFully(buffer, 0, byteCount);
        for (i = byteCount - 1; i >= 0 && buffer[i] == 0; --i) {
        }
        return i == -1 ? "" : new String(buffer, 0, i + 1, "UTF8");
    }

    protected void skipBytes(DataInputStream in, int byteCount) throws IOException {
        int skipped = in.skipBytes(byteCount);
        if (skipped != byteCount) {
            throw new EOFException("Unexpected EOF while skipping bytes");
        }
    }

    protected Date readECDate(DataInputStream in) throws IOException {
        Trace.trace(TRACE_MASKF, "-> readECDate()");
        byte[] buffer = new byte[8];
        in.readFully(buffer, 0, 8);
        if (buffer[0] == 0 && buffer[1] == 0) {
            return null;
        }
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar calendar = null;
        calendar = userContext != null ? Calendar.getInstance(TimeZone.getTimeZone("UTC"), userContext.getLocale()) : Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1, (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF);
        calendar.set(2, (buffer[2] & 0xFF) - 1);
        calendar.set(5, buffer[3] & 0xFF);
        calendar.set(10, buffer[4] & 0xFF);
        calendar.set(12, buffer[5] & 0xFF);
        calendar.set(13, buffer[6] & 0xFF);
        calendar.set(14, (buffer[7] & 0xFF) * 10);
        Trace.trace(TRACE_MASKF, "<- readECDate()");
        return calendar.getTime();
    }

    protected int readLevel(DataInputStream in) throws IOException {
        String levelStr = this.readString(in, 3);
        if (levelStr.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(levelStr);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid numeric level string \"" + levelStr + "\" found in file.");
        }
    }

    protected void writeLevelAndDate(RandomAccessFile outstream, int level, Date date) throws IOException {
        byte[] levelBuffer = new byte[3];
        String levelStr = "000" + String.valueOf(level);
        String formattedLevel = levelStr.substring(levelStr.length() - 3);
        levelBuffer = formattedLevel.getBytes("UTF8");
        outstream.write(levelBuffer);
        byte[] buffer = new byte[8];
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar calendar = null;
        calendar = userContext != null ? Calendar.getInstance(TimeZone.getTimeZone("UTC"), userContext.getLocale()) : Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        int year = calendar.get(1);
        buffer[0] = (byte)year;
        buffer[1] = (byte)(year >> 8);
        buffer[2] = (byte)(1 + calendar.get(2));
        buffer[3] = (byte)calendar.get(5);
        buffer[4] = (byte)calendar.get(10);
        buffer[5] = (byte)calendar.get(12);
        buffer[6] = (byte)calendar.get(13);
        outstream.write(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void persistECStream(boolean stagedLevel, boolean appliedLevel, boolean committedLevel) {
        block19: {
            Trace.trace("XMCLECST", "-> persistECStream()");
            outstream = null;
            try {
                block18: {
                    Trace.trace("XMCLECSF", "File " + this.fileWithPath + " is being written with status updates.");
                    outstream = new RandomAccessFile(this.fileWithPath, "rw");
                    bytesSkipped = outstream.skipBytes(30);
                    if (stagedLevel) {
                        this.writeLevelAndDate(outstream, this.stagedLevel, this.stagedDate);
                    } else {
                        bytesSkipped = outstream.skipBytes(11);
                    }
                    if (appliedLevel) {
                        this.writeLevelAndDate(outstream, this.appliedLevel, this.appliedDate);
                    } else {
                        bytesSkipped = outstream.skipBytes(11);
                    }
                    if (appliedLevel) {
                        this.writeLevelAndDate(outstream, this.appliedLevel, this.appliedDate);
                    } else {
                        bytesSkipped = outstream.skipBytes(11);
                    }
                    if (committedLevel) {
                        this.writeLevelAndDate(outstream, this.committedLevel, this.committedDate);
                        break block18;
                    }
                    bytesSkipped = outstream.skipBytes(11);
                }
                var9_6 = null;
                ** if (null == outstream) goto lbl-1000
            }
            catch (Throwable var8_13) {
                var9_8 = null;
                if (null != outstream) {
                    try {
                        outstream.close();
                    }
                    catch (IOException e) {
                        this.logError("Error on close of EC file =" + e, (short)-3955, e);
                    }
                }
                throw var8_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    outstream.close();
                }
                catch (IOException e) {
                    this.logError("Error on close of EC file =" + e, (short)-3955, e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block19;
                catch (IOException e) {
                    this.logError("IO error =" + e, (short)-3956, e);
                    var9_7 = null;
                    if (null != outstream) {
                        try {
                            outstream.close();
                        }
                        catch (IOException e) {
                            this.logError("Error on close of EC file =" + e, (short)-3955, e);
                        }
                    }
                }
            }
        }
        Trace.trace("XMCLECST", "<- persistECStream()");
    }

    protected void logError(String errorString, short errorId) throws HException {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        HException hexc = new HException(errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.displayableError = new LocalizableText(errorString);
        throw hexc;
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.displayableError = new LocalizableText(errorString);
    }
}

